Rem
Rem Copyright (c) 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      enq_tibrv.sql - Creates and enqueues a message.
Rem
Rem    DESCRIPTION
Rem      This script creates a message with payload type SYS.MGW_TIBRV_MSG_T 
Rem      and enqueues it to the queue MGWUSER.MGW_TIBRV_SRC.
Rem

set serveroutput on;
declare
    enqueue_options      dbms_aq.enqueue_options_t;
    message_properties   dbms_aq.message_properties_t;
    msgid                RAW(16);
    payload		 sys.mgw_tibrv_msg_t;
    text_body		 sys.mgw_text_value_t;
    msgDate              Date;
BEGIN
  -- Construct the message from its constituent parts.
  payload := sys.mgw_tibrv_msg_t.construct;

  msgDate := SYSDATE;
  payload.add_datetime('Time', 0, msgDate);
  payload.add_string('Content',0, 'Hello World');

  -- Enqueue the message.
  dbms_aq.enqueue(queue_name         => 'mgwuser.mgw_tibrv_src',
                  enqueue_options    => enqueue_options,
                  message_properties => message_properties,
                  payload            => payload,
                  msgid              => msgid);
  commit;

  dbms_output.put_line('A message is sent to queue mgwuser.mgw_tibrv.src');

  dbms_output.put_line('Field Time'    || '   ' ||
                       to_char(msgDate, 'YYYY-MM-DD HH24:MI:SS'));
  dbms_output.put_line('Field Content' || '   ' || 'Hello World');
END enqueue;
/
